/**
 * BotFake Recorder - Background Service Worker
 * Manages extension state and badge
 */

// Update badge when recording
chrome.storage.onChanged.addListener((changes, namespace) => {
  if (namespace === 'local') {
    if (changes.isRecording) {
      if (changes.isRecording.newValue) {
        chrome.action.setBadgeText({ text: 'REC' });
        chrome.action.setBadgeBackgroundColor({ color: '#ff4757' });
      } else {
        chrome.action.setBadgeText({ text: '' });
      }
    }
    
    if (changes.actionsCount && changes.actionsCount.newValue > 0) {
      chrome.storage.local.get('isRecording', (state) => {
        if (state.isRecording) {
          chrome.action.setBadgeText({ text: String(changes.actionsCount.newValue) });
        }
      });
    }
  }
});

// Listen for messages from content scripts
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'RECORDING_UPDATE') {
    chrome.storage.local.set({ actionsCount: message.actionsCount });
    
    // Update badge
    chrome.action.setBadgeText({ text: String(message.actionsCount) });
  }
});

// Clear state on extension install/update
chrome.runtime.onInstalled.addListener(() => {
  chrome.storage.local.set({
    isRecording: false,
    actionsCount: 0
  });
  chrome.action.setBadgeText({ text: '' });
});

